<?php

namespace Database\Seeders;

use App\Models\Landlord\Blog;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BlogSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'language_id' => 1,
                'title' => 'The Ambiguity Factor in Leadership Communication.',
                'slug' => 'the-ambiguity-factor-in-leadership-communication',
                'description' => '<p>As a leader, have you planned for the Ambiguity Factor in your leadership communication plans? When it comes to communicating about change, there are oodles of reasons why the launch of a new system goes awry— competing values, unclear objectives, unrealistic deadlines, budget constraints and so on.</p>
                                <p>From a social psychology standpoint, here’s another reason that gets buried underneath the more observable causes:  human beings’ reaction to leadership communications about a change.  Many leaders trot out the old saw “people fear change,” yet so few rarely factor that aspect into their leadership communication plans for introducing something new.<br /><br /></p>
                                <p>For example, let’s say that you’re a Vice President that has 250 people in your division and you need to announce a large system implementation.  First up: the project plan.  You identify key players and ensure that plan is created, with deadlines and accountabilities.  Then, you create  a communication plan.  Maybe you’ll hold kick-off meetings, or you’ll do a video town hall, or an internal video newsletter, or you’ll send an email outlining the plan.  If you have a really strong employee communication plan, you’ll probably also hold some sort of feedback session to gather input from employees.  To follow it up, you’ll enlist the support of your management team to reinforce the message via departmental meetings.</p>
                                <p>Whew!  The Plan is rolled out and employees are on board. Right? Wrong.</p>
                                <p>Here’s the deal:<strong> just because you said it, doesn’t mean they get it</strong>.  “But I communicated it several times and in several ways!” you’ll protest. Yep, you did.  But it takes awhile for these things to sink in. According to <a href="https://www.axioshq.com/insights/its-reinforce-not-repeat-a-smarter-way-to-cascade-essential-information-around-your-organization">Axios HQ,</a> less than 50% of employees feel they have enough context to do their jobs properly.</p>
                                <p>So here’s what <em>really</em> happened:</p>
                                <p>The rumor mill kicks into action. In hallway conversations and via snippets of emails, texting, and Slack, people talk. With each iteration of a person’s reaction to The Plan, information gets twisted and reshaped, sometimes into an unrecognizable form of the original Plan.  One of my favorite sayings is “In the absence of information, people make it up—and wow, are they creative.”   Whenever there’s a perceived information vacuum, people do indeed get creative—and, I’ve noticed—they tend to go to the extreme.  So if, for example, a change is announced in which there will be “some” new job responsibilities for X job title, it gets re-crafted into “my entire job is going to change!”</p>
                                <blockquote class="wp-block-quote">
                                <p>In the absence of information, people make it up. And wow, are they creative!</p>
                                </blockquote>
                                <p>Notice that I said <em>perceived</em> information void.  It’s not that leaders fail to communicate, it’s that they underestimate the number of times they need to do so.  Call it the Ambiguity Factor— for each organizational layer an employee is removed from the decision-making, the level of ambiguity increases.</p>
                                <p>So it’s your job as a leader to <a href="https://people-equation.com/leaders-help-people-connect-the-dots/">connect the dots</a>. Leaders who are at the epicenter of the decision-making are much more comfortable with The Plan because they helped shape it. As leaders communicate the plan, they need to listen for resistance and lack of clarity.  Then, they need to act quickly to clarify misperceptions and offer reassurance when necessary.  Because if they don’t, the Ambiguity Factor kicks into overdrive and employees will don their creative thinking caps and create their own perception of reality.</p>
                                <p> </p>',
                'image' => 'rVWtwviUhh.jpg',
                'meta_title' => 'Technology',
                'meta_description' => 'Technology',
                'og_title' => 'Technology',
                'og_description' => 'Technology',
                'og_image' => 'rVWtwviUhh.jpg',
            ],
            [
                'language_id' => 1,
                'title' => 'How to better manage your time at work ?',
                'slug' => 'how-to-better-manage-your-time-at-work ?',
                'description' => '<p class="clearfix">Time management is planning how to efficiently use and deliberately control the time you spend to maximize productivity. In short, get more done in less time. Other upsides include:</p>
                                <ul>
                                <li>Better work quality</li>
                                <li>Less stress</li>
                                <li>More time to work on strategic or creative projects</li>
                                <li>Less procrastination</li>
                                <li>More self-confidence</li>
                                </ul>
                                <p class="clearfix">Here’s how to get started:<br /><br /><strong>1. Know how you’re spending your time<br /></strong></p>
                                <p>If your productivity is measured by output over a certain period, lost time can mean dollars out the window. Just like creating a budget, you have to track what you’re <em>actually</em> spending your time on to reveal any areas or habits that are blocking you from reaching your goals.</p>
                                <p class="clearfix">Start with a time check. Time-tracking tools like RescueTime can tell you, based on the categories you set up, how many hours you’re productive in a day versus how much time you’re spending on non-work-related activities, such as browsing social media or shopping.<br /><br /></p>
                                <h3 class="" data-js-heading-tracker="2">2. Stick to a daily schedule</h3>
                                <p class="clearfix">Go beyond “I have eight hours to do XYZ.” Create a daily schedule with allotted time blocks for different tasks. Sticking to it is the key to success.</p>
                                <ul>
                                <li><strong>Create realistic timelines</strong>. People overestimate their capacity to get things done, a phenomenon scientists call “<a href="https://web.mit.edu/curhan/www/docs/Articles/biases/67_J_Personality_and_Social_Psychology_366,_1994.pdf" target="_blank" rel="noopener noreferrer">planning fallacy</a>,” which usually results in overly optimistic delivery estimates. Add time buffers between tasks so that even if one goes over the time limit, the overall schedule stays intact.</li>
                                <li><strong>Give your undivided attention</strong>. Avoid sneaking to non-work-related sites (or whatever it is you’re not supposed to be doing) during work hours. Close all those “for later” browser tabs. Turn off your phone or stow it out of reach until it’s time for a scheduled break. Again, self-discipline is your best friend here.</li>
                                </ul>
                                <h3 class="is-active" data-js-heading-tracker="3">3. Prioritize</h3>
                                <p class="clearfix">To-do lists can be productivity lifesavers. But if you’re not careful, they can get so big and overwhelming that you don’t know where to start. A tool known as the <a href="https://todoist.com/productivity-methods/eisenhower-matrix" target="_blank" rel="noopener noreferrer">Eisenhower Matrix</a> can help you decide what to prioritize according to importance and urgency. Using this decision matrix, you can break down your list by:</p>
                                <ul>
                                <li><strong>Do immediately</strong>: Important tasks with defined deadlines, or ones you’ve put off for so long they’re now overdue</li>
                                <li><strong>Schedule for later</strong>: Important tasks with no defined deadlines</li>
                                <li><strong>Delegate</strong>: Tasks that someone else can do</li>
                                <li><strong>Delete</strong>: Tasks you can eliminate because they’re not critical to your goals or mission</li>
                                </ul>
                                <p class="clearfix"><br /><br /></p>
                                <p class="clearfix"><strong> </strong></p>
                                <p class="clearfix"><br /><br /><br /></p>',
                'image' => 'lHhA4iRkdt.jpg',
                'meta_title' => 'how-to-better-manage-your-time-at-work',
                'meta_description' => 'how-to-better-manage-your-time-at-work',
                'og_title' => 'how-to-better-manage-your-time-at-work',
                'og_description' => 'how-to-better-manage-your-time-at-work',
                'og_image' => 'lHhA4iRkdt.jpg',
            ],
            [
                'language_id' => 1,
                'title' => 'Human Resource Management (HRM)',
                'slug' => 'human-resource-management-HRM',
                'description' => '<p>Human resource management (HRM) is the practice of recruiting, hiring, deploying and managing an organizations employees. HRM is often referred to simply as human resources (HR). A company or organizations HR department is usually responsible for creating, putting into effect and overseeing policies governing workers and the relationship of the organization with its employees. The term <em>human resources</em> was first used in the early 1900s, and then more widely in the 1960s, to describe the people who work for the organization, in aggregate.<br /><br /></p>
                                    <p>HRM is employee management with an emphasis on employees as assets of the business. In this context, employees are sometimes referred to as <em>human capital</em>. As with other business assets, the goal is to make effective use of employees, reducing risk and maximizing return on investment (<a href="https://www.techtarget.com/searchcio/definition/ROI">ROI</a>).</p>
                                    <p>The modern term <em>human capital management (</em><em><a href="https://www.techtarget.com/searchhrsoftware/definition/human-capital-management-HCM">HCM</a></em><em>)</em> is often used by large and midsize companies when discussing <a href="https://www.techtarget.com/searchhrsoftware/definition/HR-technology">HR technology</a>.<br /><br /><br /></p>
                                    <h2 class="section-title">The importance of human resource management</h2>
                                    <p>The purpose of HRM practices is to manage the people within a workplace to achieve the organizations mission and reinforce the <a href="https://www.techtarget.com/whatis/definition/corporate-culture">corporate culture</a>. When people management is done effectively, HR managers can help recruit new employees who have the skills to further the companys goals. HR professionals also aid in the training and professional development of employees to meet the organizations objectives.</p>
                                    <p>A company is only as good as its employees, making HRM a crucial part of maintaining or improving the health of the business. Additionally, HR managers monitor the state of the job market to help the organization stay competitive. This could include ensuring compensation and benefits are competitive, events are planned to keep employees from burning out and job roles are adapted based on the market.<br /><br /></p>
                                    <h2 class="section-title">How does HRM work?</h2>
                                    <p>HR professionals manage the day-to-day execution of HR-related functions. Typically, human resources is a standalone department within an organization.</p>
                                    <p>HR departments vary in the size, structure and nature of their individual positions. For small organizations, one <a href="https://www.techtarget.com/searchhrsoftware/definition/human-resources-HR-generalist">HR generalist</a> might perform a broad array of functions. Larger organizations have several <a href="https://www.techtarget.com/searchhrsoftware/tip/Nine-different-HR-roles-and-responsibilities-demystified">HR professionals who handle specialized roles</a>, such as recruiting, immigration and visas, talent management, employee benefits and compensation. Though these HR positions are specialized, job functions might still overlap.</p>
                                    <p>Amazon is an example of a large company with multiple types of specialized HR positions. The companys career website lists the following HR job titles.</p>
                                    <p><br /><br /></p>',
                'image' => 'chLB0RoMzU.jpg',
                'meta_title' => 'human-resource-management',
                'meta_description' => 'human-resource-management',
                'og_title' => 'human-resource-management',
                'og_description' => 'human-resource-management',
                'og_image' => 'chLB0RoMzU.jpg',
            ],
        ];

        Blog::insert($data);
    }
}
