<?php $__env->startSection('content'); ?>

<section>
    <div class="col-md-12">
        <div class="card">
            <div class="card-header with-border">
                <span id="form_result"></span>
                <h3 class="card-title"> <?php echo e(__('Create Invoice')); ?> </h3>
            </div>
            <div class="card-body">
                <form  name="create_invoice" id="create_invoice" autocomplete="off" class="form" method="post" accept-charset="utf-8">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="invoice_number"><?php echo e(__('Invoice Number')); ?></label>
                                <input class="form-control" placeholder="<?php echo e(__('Invoice Number')); ?>" name="invoice_number" type="text" value="<?php echo e($invoice_number); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="project"><?php echo e(trans('file.Project')); ?></label>
                                <select name="project_id" id="project_id" class="form-control selectpicker "
                                        data-live-search="true" data-live-search-style="contains"
                                        title='<?php echo e(__('Selecting',['key'=>trans('file.Project')])); ?>...'>
                                    <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($project->id); ?>"><?php echo e($project->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="invoice_date"><?php echo e(__('Invoice Date')); ?></label>
                                <input class="form-control date" required placeholder="Invoice Date"  name="invoice_date" type="text" value="">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="invoice_due_date"><?php echo e(__('Due Date')); ?></label>
                                <input class="form-control date" required placeholder="Due Date"  name="invoice_due_date" type="text" value="">
                            </div>
                        </div>
                    </div>
                    <hr>

                    <div id="item-list">
                        <div id="1" class="item">
                            <div class="row">
                                <div class="form-group mb-1 col-sm-12 col-md-3">
                                    <label for="item_name"><?php echo e(trans('file.Item')); ?></label>
                                    <br>
                                    <input type="text" class="form-control item_name" name="item_name[]" id="item_name" placeholder="<?php echo e(trans('file.Item')); ?>">
                                </div>
                                <div class="form-group mb-1 col-sm-12 col-md-1">
                                    <label for="qty_hrs" class="cursor-pointer"><?php echo e(trans('file.Qty')); ?></label>
                                    <br>
                                    <input type="number" class="form-control qty_hrs calc" required name="qty_hrs[]" value="1" min="1">
                                </div>
                                <div class="form-group mb-1 col-sm-12 col-md-2">
                                    <label for="unit_price"><?php echo e(__('Unit Price')); ?></label>
                                    <br>
                                    <input class="form-control unit_price calc" required name="unit_price[]" value="0" />
                                </div>
                                <div class="form-group mb-1 col-sm-12 col-md-2">
                                    <label for="tax_type"><?php echo e(__('Tax Type')); ?></label>
                                    <br>
                                    <select name="tax_type_id[]" required class="form-control tax_type" data-live-search="true" data-live-search-style="contains" title='<?php echo e(__('Tax Type')); ?>'>
                                        <option value=""><?php echo e(__('Tax Type')); ?></option>
                                    <?php $__currentLoopData = $tax_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($tax_type->type == 'fixed'): ?>
                                                <option value="$<?php echo e($tax_type->rate); ?>"><?php echo e($tax_type->name); ?>($<?php echo e($tax_type->rate); ?>)</option>
                                            <?php else: ?>
                                                <option value="<?php echo e($tax_type->rate); ?>"><?php echo e($tax_type->name); ?>(<?php echo e($tax_type->rate); ?>%)</option>
                                            <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group mb-1 col-sm-12 col-md-1">
                                    <label for="tax_type"><?php echo e(__('Tax Rate')); ?></label>
                                    <br>
                                    <input type="text" class="form-control tax_amount" name="tax_amount[]" value="0"  readonly="readonly" />
                                </div>
                                <div class="form-group mb-1 col-sm-12 col-md-2">
                                    <label for="profession"><?php echo e(__('Sub Total')); ?></label>
                                    <input type="text" class="form-control sub-total-item" readonly="readonly" name="sub_total_item[]" value="0" />
                                    <!-- <br>-->
                                    <p class="form-control-static d-none"><span class="amount-html">0</span></p>
                                </div>
                                <div class="form-group col-sm-12 col-md-1 text-xs-center mt-2">

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group overflow-hidden1">
                        <div class="col-xs-12">
                            <button type="button" data-repeater-create="" class="btn btn-primary" id="add-invoice-item"> <i class="fa fa-plus"></i> <?php echo e(__('Add Item')); ?></button>
                        </div>
                    </div>
                    <input type="hidden" class="items-sub-total" name="items_sub_total" value="0" />
                    <input type="hidden" class="items-tax-total" name="items_tax_total" value="0" />
                    <div class="row">
                        <div class="col-md-7 col-sm-12 text-xs-center text-md-left">&nbsp; </div>
                        <div class="col-md-5 col-sm-12">
                            <div class="table-responsive">
                                <table class="table">
                                    <tbody>
                                    <tr>
                                        <td><?php echo e(__('Sub Total')); ?></td>
                                        <td class="text-xs-right"><span id="sub_total" class="sub_total">0</span></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo e(__('Tax Rate')); ?></td>
                                        <td class="text-xs-right"><span id="total_tax" class="total_tax">0</span></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2"><table class="table table-bordered">
                                                <tbody>
                                                <tr>
                                                    <td><strong><?php echo e(__('Discount Type')); ?></strong></td>
                                                    <td><strong><?php echo e(trans('file.Discount')); ?></strong></td>
                                                    <td><strong><?php echo e(__('Discount Amount')); ?></strong></td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <div class="form-group">
                                                            <select name="discount_type" class="form-control discount_type">
                                                                <option value="0"><?php echo e(trans('file.Flat')); ?></option>
                                                                <option value="1"><?php echo e(trans('file.Percent')); ?></option>
                                                            </select>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="form-group">
                                                            <input type="text" name="discount_figure" class="form-control discount_figure text-right" value="0" required>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="form-group">
                                                            <input type="text" readonly="" name="discount_amount" value="0" class="discount_amount form-control text-right">
                                                        </div>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table></td>
                                    </tr>
                                    <input type="hidden" class="grand_total" id="grand_total_form" name="grand_total" value="0" />
                                    <tr>
                                        <td><?php echo e(__('Grand Total')); ?></td>
                                        <td class="text-xs-right"><span id="grand_total" class="grand_total">0</span></td>
                                    </tr>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-xs-12 mb-2 file-repeaters"> </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <label for="invoice_note"><?php echo e(__('Invoice Note')); ?></label>
                            <textarea name="invoice_note" class="form-control"></textarea>
                        </div>
                    </div>

                    <div id="invoice-footer">
                        <div class="row">
                            <div class="col-md-7 col-sm-12">
                                <p>&nbsp;</p>
                            </div>
                            <div class="col-md-5 col-sm-12 text-xs-center">
                                <button type="submit" name="invoice_submit" class="btn btn-primary pull-right my-1 mr-3"><i class="fa fa fa-check-square-o"></i> <?php echo e(__('Submit Invoice')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>


<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
    (function($) {
        "use strict";

        let date = $('.date');
        date.datepicker({
            format: '<?php echo e(env('Date_Format_JS')); ?>',
            autoclose: true,
            todayHighlight: true
        });


        $(document).on('click', '#add-invoice-item', function(){

            var item_id = parseInt($('#item-list .item:last').attr('id'))+1;

            $('#item-list').append('<div id="'+item_id+'" class="item"><div class="row"><div class="form-group mb-1 col-sm-12 col-md-3"><label for="item_name">Item</label><br><input type="text" class="form-control item_name" name="item_name[]" id="item_name" placeholder="<?php echo e(trans('file.Item')); ?>"></div><div class="form-group mb-1 col-sm-12 col-md-1"><label for="qty_hrs" class="cursor-pointer"><?php echo e(trans('file.Qty')); ?></label><br><input type="number" class="form-control qty_hrs calc" name="qty_hrs[]" value="1"></div><div class="skin skin-flat form-group mb-1 col-sm-12 col-md-2"><label for="unit_price"><?php echo e(__('Unit Price')); ?></label><br><input class="form-control unit_price calc" type="text" name="unit_price[]" value="0" /></div><div class="form-group mb-1 col-sm-12 col-md-2"><label for="tax_type"><?php echo e(__('Tax Type')); ?></label><br><select name="tax_type_id[]" class="tax-types form-control tax_type" data-live-search="true" data-live-search-style="contains" title="<?php echo e(__('Tax Type')); ?>"><option value=""><?php echo e(__('Tax Type')); ?></option> </select></div><div class="form-group mb-1 col-sm-12 col-md-1"><label for="tax_type"><?php echo e(__('Tax Rate')); ?></label><br><input type="text" class="form-control tax_amount" name="tax_amount[]" value="0"  readonly="readonly" /></div><div class="form-group mb-1 col-sm-12 col-md-2"><label for="profession"><?php echo e(__('Sub Total')); ?></label><input type="text" class="form-control sub-total-item" readonly="readonly" name="sub_total_item[]" value="0" /><p class="form-control-static d-none"><span class="amount-html">0</span></p></div><div class="form-group col-sm-12 col-md-1 text-xs-center mt-2"><label for="profession">&nbsp;</label><br><button type="button" class="btn icon-btn btn-xs btn-danger waves-effect waves-light remove-invoice-item" data-repeater-delete=""> <span class="fa fa-trash"></span></button></div></div></div>');

            var tax_type = <?php echo json_encode($tax_types, 15, 512) ?>;


            tax_type.forEach(function(v) {
                if(v.type == 'fixed') {
                    $('#item-list #'+item_id+' .tax-types').append("<option value='$"+v.rate+"'>"+v.name+" ($"+v.rate+")</option>");

                } else {
                    $('#item-list #'+item_id+' .tax-types').append("<option value='"+v.rate+"'>"+v.name+" ("+v.rate+"%)</option>");
                }
            });
        });


        $('#create_invoice').on('submit', function(event) {
            event.preventDefault();
            let sub_total = Number($('#sub_total').text());
            let total_tax =  Number($('#total_tax').text());
            let grand_total = Number($('#grand_total').text());

            $('.items-sub-total').val(sub_total);
            $('.items-tax-total').val(total_tax);
            $('#grand_total_form').val(grand_total);

            $.ajax({
                url: "<?php echo e(route('invoices.store')); ?>",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                cache: false,
                processData: false,
                dataType: "json",
                success: function (data) {
                    let html = '';
                    if (data.errors) {
                        html = '<div class="alert alert-danger">';
                        for (let count = 0; count < data.errors.length; count++) {
                            html += '<p>' + data.errors[count] + '</p>';
                        }
                        html += '</div>';
                    }
                    if (data.error) {
                        html = '<div class="alert alert-danger">' + data.error + '</div>';
                    }
                    if (data.success) {
                        html = '<div class="alert alert-success">' + data.success + '</div>';
                        setTimeout(function(){
                            $('#create_invoice')[0].reset();
                            $('#total_tax').html('');
                            $('#sub_total').html('');
                            $('#grand_total').html('');
                            $('.selectpicker').selectpicker('refresh');
                        }, 2000);
                        window.location.href="<?php echo e(route('invoices.create')); ?>";
                    }
                    $('#form_result').html(html).slideDown(100).delay(3000).slideUp(100);

                }
            });
        });
    })(jQuery);

</script>

<script type="text/javascript" src="<?php echo e(asset('js/compiled_from_ts/invoice-create.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home3/cbspdcom/learning.cbspd.com/peoplepro/resources/views/projects/invoices/create.blade.php ENDPATH**/ ?>