
<!-- navbar-->
<header class="header">
    <nav class="navbar">
        <div class="container-fluid">
            <div class="navbar-holder d-flex align-items-center justify-content-between">
                <a id="toggle-btn" href="#" class="menu-btn"><i class="dripicons-menu"> </i></a>
                <span class="brand-big" id="site_logo_main">
                    <?php if($generalSetting->site_logo): ?>
						<img src="<?php echo e(asset('landlord/images/logo/'.$generalSetting->site_logo)); ?>" width="140" height="70">
                        &nbsp; &nbsp;
                    <?php endif; ?>
                </span>


                <ul class="nav-menu list-unstyled d-flex flex-md-row align-items-md-center">
                    <li class="nav-item">
                        <a class="dropdown-header-name" style="padding-right: 10px" href="<?php echo e(url('/optimize')); ?>" data-toggle="tooltip" title="Clear all cache with refresh"><i class="fa fa-refresh"></i></a>
                    </li>
                    <li class="nav-item">
                        <a class="dropdown-header-name" style="padding-right: 10px" href="<?php echo e(route('landingPage.index')); ?>" target="_blank" title="View Website"><i class="dripicons-preview"></i></a>
                    </li>
                    <li class="nav-item"><a id="btnFullscreen" data-toggle="tooltip" title="<?php echo e(__('Full Screen')); ?>"><i class="dripicons-expand"></i></a></li>
                    <li class="nav-item">
                        <a rel="nofollow" href="#" class="nav-link dropdown-item" data-toggle="tooltip"
                           title="<?php echo e(__('Language')); ?>">
                            <i class="dripicons-web">
                                <?php echo e(Session::has('TempSuperAdminLocale') ? strtoupper(Session::get('TempSuperAdminLocale')) : strtoupper(Session::get('DefaultSuperAdminLocale'))); ?>

                            </i>
                        </a>
                        <ul class="right-sidebar">
                            <?php if(config('database.connections.peopleprosaas_landlord')): ?>
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="<?php echo e(route('lang.switch',$lang->locale)); ?>"><?php echo e($lang->name.' ('.$lang->locale.')'); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="<?php echo e(route('lang.switch',$lang)); ?>"><?php echo e($lang); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="https://peopleprohrmsaas.com/central-documentation" target="_blank" data-toggle="tooltip"
                           title="<?php echo e(__('Documentation')); ?>">
                            <i class="dripicons-information"></i>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a rel="nofollow" id="notify-btn" href="#" class="nav-link dropdown-item" data-toggle="tooltip"
                           title="<?php echo e(__('Notifications')); ?>">
                            <i class="dripicons-bell"></i>
                            <?php if(auth()->user()->unreadNotifications->count()): ?>
                                <span class="badge badge-danger">
                                    <?php echo e(auth()->user()->unreadNotifications->count()); ?>

                                </span>
                            <?php endif; ?>
                        </a>
                        <ul class="right-sidebar">
                            <li class="header">
                                <span class="pull-right"><a href="<?php echo e(route('clearAllNotification')); ?>"><?php echo e(__('Clear All')); ?></a></span>
                                <span class="pull-left"><a href="<?php echo e(route('seeAllNotification')); ?>"><?php echo e(__('See All')); ?></a></span>
                            </li>
                            <?php $__currentLoopData = auth()->user()->notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a class="unread-notification"
                                       href=<?php echo e($notification->data['link']); ?>><?php echo e($notification->data['data']); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>

                    <li class="nav-item">
                        <a rel="nofollow" href="#" class="nav-link dropdown-item">
                            <?php if(isset(auth()->user()->profile_photo)): ?>
                                <img class="profile-photo sm mr-1" src="<?php echo e(asset('landlord/images/profile/'.auth()->user()->profile_photo)); ?>">
                            <?php else: ?>
                                <img class="profile-photo sm mr-1" src="<?php echo e(asset('uploads/profile_photos/avatar.jpg')); ?>"><span> Admin</span>
                            <?php endif; ?>
                        </a>
                        <ul class="right-sidebar">
                            <li>
                                <a href="<?php echo e(route('admin.profile')); ?>">
                                    <i class="dripicons-user"></i>
                                    <?php echo e(trans('file.Profile')); ?>

                                </a>
                            </li>
                            <li>
                                <form id="logout-form" action="<?php echo e(route('landlord.logout')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button class="btn btn-link" type="submit"><i class="dripicons-exit"></i> <?php echo e(trans('file.logout')); ?></button>
                                </form>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
</header>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
    (function ($) {

        "use strict";

        $('#notify-btn').on('click', function (event) {
            event.preventDefault();
            $('.badge.badge-danger').empty();
            $.ajax({
                url: '<?php echo e(route('markAsReadNotification')); ?>',
                dataType: "json",
                success: function (result) {
                },
            });
        })

    })(jQuery);
</script>

<?php $__env->stopPush(); ?>
<?php /**PATH D:\laragon\www\peopleprosaas\resources\views/landlord/super-admin/partials/header.blade.php ENDPATH**/ ?>